function [tout, yout, P1, P2] = FEM_Solver_Parabolic_Neumann_Time( dt, A, k, C11, C12, C21, C22, cinitial, tfinal, tstep)
%Run a FEM approximation for diffusion. Space bdy nodes constant values.
%   Parabolic problem is of type Au_t - div[kC*grad u] = 0. UNLIKE other
%   codes, here the A - C22 are column vectors which correspond to the
%   nodal values of the equation coefficients ordered like Nodes under
%   Lists. The same is for cinitial which gives the nodal sample of the
%   initial distribution. The Neumann data is handled through a call on the
%   script NValue.  In partic, to change the Neumann data, change the
%   function f given there.
%   The diffusion starts at time t = 0 and runs until tfinal
%   along tstep.  tout is a column vector of time values. yout(:,j) are
%   nodal values at time t = tout(j,1); 

%NOTE: This program was written sufficiently general that the k value may
%actually be a matrix.  For diffusion lab purposes.  


%Generate lists
tri = dt.Triangulation;
vert = dt.X;
[Edge, Etri, Boundary, Vmem, VNodal, ENodal, Nodal, Nodal_Bud, Nodes, NTri, Nmem] = Lists(tri, vert);

%Rewrite the diffusion coefficient as k times identity matrix.
B11 = k;
B12 = k - k;
B21 = k-k;
B22 = k;

%From our initial lists extract the boundary data from the interior data.
cbd = cinitial(Nodal_Bud(2,1)+1:Nodal_Bud(4,1),1);
cinitial = cinitial(1:Nodal_Bud(2,1),:);

%Reformat the A-C22 terms as expected by Stiff Prin
A = Q_FNodal(NTri,Nodes,A);
B11 = Q_FNodal(NTri,Nodes,B11);
B12 = Q_FNodal(NTri,Nodes,B12);
B21 = Q_FNodal(NTri,Nodes,B21);
B22 = Q_FNodal(NTri,Nodes,B22);
C11 = Q_FNodal(NTri,Nodes,C11);
C12 = Q_FNodal(NTri,Nodes,C12);
C21 = Q_FNodal(NTri,Nodes,C21);
C22 = Q_FNodal(NTri,Nodes,C22);


% Extract the matrices P1 and P2 for the homogenous case with no forcing
% term and that the boundary data stays constant: P1c' + P2c = 0

[P1, P2] = Stiff_Prin(dt,A,B11,B12,B21,B22,C11,C12,C21,C22);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Neumann Assembly %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%The output: P1 and P2 but over ALL nodals, not only interior.
%Nval is the forcing vector for the right hand side in below relation.

%Recall Stiff Prin did not do computations at the boundary, for it assumed
%we had a steady state dirichlet assignment at the boundary.  We need now
%to augment the matrices P1 and P2 to accomodate for the presence of
%Neumann data.  These assemblies are of the type for i rows and j columns
%\sum_{j}{\int \psi_{i}A\psi_{j} }c'_{j} + \sum_{j}{\int
%\nabla\psi_{i}\cdot kC\nabla\psi_{j}}c_{j} =
%\int_{\partial}\psi_{i}Ndata

%Recall the structure of stiff prin: Loop over all interior nodes psi_{i}.
%Find triangles to which psi_{i} belongs.  To each such triangle loop over
%nodes psi_{j} belonging to it.  Integrate the above paragraph integrals
%over THAT triangle, and add it to the preexisting entry for (i,j). By only
%integrating for that triangle, when we loop to the next one containing
%psi_{i}, if two triangles overlap at psi_{j} too, we don't erroneously
%duplicate contributions by psi_{j} already accounted for.  What we did
%amounts to splitting up the area integral for the psi_{i}, psi_{j} pair 
%across two bordering triangles. Because Stiff_Prin only worked with
%interior nodes, the boundary condition forcing term was zero. 

%For the Neumann integration, we set Nval = [zeros(numnodal-numbd,1); f] with
%f = a Nodal_Bud(4,1)-Nodal_Bud(2,1) by 1 array with entries
%\int_{\partial} \psi_{i} Nd\sigma and i ranging over the nodal boundary
%functions ie i:Nodal_Bud(2,1)+1:Nodal_Bud(4,1)

numnodal = size(Nodal,1); %Number of Nodal Basis Functions
numbd = 2*size(Boundary,1); %Number of Boundary Nodes for a closed curve
numtri = size(dt.Triangulation,1); %Number of triangles
P1bd = zeros(numbd,numnodal);
P2bd = zeros(numbd,numnodal);

[W,Points] = Weights(1); %Extract the weights and Points on std element

%Grab the nodal splines formatted to each triangle as they're indexed by the
%nodes.
NSpline = zeros(numtri,6,3,numnodal);
for i=1:numnodal 
    c = zeros(numnodal,1);
    c(i,1) = 1;
    NSpline(:,:,:,i) = Q_FNodal(NTri, Nodes, c);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Augment Matrix on c' %%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for i=Nodal_Bud(2,1)+1:Nodal_Bud(4,1) %Loop over all nodal functions on the boundary.
                                      %Recall in Nodal_Bud, the boundary vertices begin at
                                      %the left and end at the right in the i index.
    k=1;
    while k<= size(Nmem,2) && Nmem(i,k) ~= 0 %Nmem(i,k) is nonvacuous triangle to which belong

         Triangle = [[vert(tri(Nmem(i,k),1),1) vert(tri(Nmem(i,k),1),2)];[vert(tri(Nmem(i,k),2),1) vert(tri(Nmem(i,k),2),2)];[vert(tri(Nmem(i,k),3),1) vert(tri(Nmem(i,k),3),2)]]; %Extract the triangle, 

         [PointsElement,J] = Std_to_Tri(Triangle, Points); %Map the Points into our triangle so know where to evaluate at.
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         Triangle = [Nodes(NTri(Nmem(i,k),1),:);Nodes(NTri(Nmem(i,k),2),:);Nodes(NTri(Nmem(i,k),3),:);Nodes(NTri(Nmem(i,k),4),:);Nodes(NTri(Nmem(i,k),5),:);Nodes(NTri(Nmem(i,k),6),:)];
         Ci = Q_Terp(Triangle, NSpline(Nmem(i,k),:,3,i)'); %Extract Quadratic Coefficients
         CA = Q_Terp(Triangle, A(Nmem(i,k),:,3)'); %"
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         Evali = Ci(1,1)+Ci(1,2)*PointsElement(:,1) + Ci(1,3)*PointsElement(:,2) + Ci(1,4)* PointsElement(:,1).*PointsElement(:,2) + Ci(1,5)*PointsElement(:,1).^2 + Ci(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalA = CA(1,1)+CA(1,2)*PointsElement(:,1) + CA(1,3)*PointsElement(:,2) + CA(1,4)* PointsElement(:,1).*PointsElement(:,2) + CA(1,5)*PointsElement(:,1).^2 + CA(1,6)*PointsElement(:,2).^2;
         J = abs(J);   
         for r = 1:6 %Go to all nodes for this triangle.
              %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
              Cj = Q_Terp(Triangle, NSpline(Nmem(i,k),:,3,NTri(Nmem(i,k),r))'); %Extract Quadratic Coefficients
              %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
              Evalj = Cj(1,1)+Cj(1,2)*PointsElement(:,1) + Cj(1,3)*PointsElement(:,2) + Cj(1,4)* PointsElement(:,1).*PointsElement(:,2) + Cj(1,5)*PointsElement(:,1).^2 + Cj(1,6)*PointsElement(:,2).^2;
              %Integrate by quadrature
              Z = (Evali.*EvalA);
              Z = Z.*Evalj;
              Z = W*Z;
              P1bd(i-Nodal_Bud(2,1),NTri(Nmem(i,k),r)) = J*Z + P1bd(i-Nodal_Bud(2,1),NTri(Nmem(i,k),r));
          end
          k = k + 1; %Go to next possible triangle
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Augment Matrix on c %%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Entries here are of type \sum_j {\nabla\psi_i B*C*\nabla \psi_j }
for i=Nodal_Bud(2,1)+1:Nodal_Bud(4,1)
    k=1;
    while k<= size(Nmem,2) && Nmem(i,k)~= 0 %Again cycle through all triangles for which our nodal belonds
       Triangle = [[vert(tri(Nmem(i,k),1),1) vert(tri(Nmem(i,k),1),2)];[vert(tri(Nmem(i,k),2),1) vert(tri(Nmem(i,k),2),2)];[vert(tri(Nmem(i,k),3),1) vert(tri(Nmem(i,k),3),2)]]; %Extract the triangle, 

         [PointsElement,J] = Std_to_Tri(Triangle, Points); %Map the Points into our triangle so know where to evaluate at.  Unlike nonderivative, we need the points in the triangle bc we'll need to take the deriv
                                                           %in the coordinates of the domain space.
                                                           
         
         Triangle = [Nodes(NTri(Nmem(i,k),1),:);Nodes(NTri(Nmem(i,k),2),:);Nodes(NTri(Nmem(i,k),3),:);Nodes(NTri(Nmem(i,k),4),:);Nodes(NTri(Nmem(i,k),5),:);Nodes(NTri(Nmem(i,k),6),:)];                                                  
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         %Mid = [1/2*Triangle(1,:)+1/2*Triangle(2,:); 1/2*Triangle(2,:)+1/2*Triangle(3,:); 1/2*Triangle(3,:)+1/2*Triangle(1,:)];
         %TriangleElement = [Triangle; Mid]; %Augment the triangle by its midpoints
         Ci = Q_Terp(Triangle, NSpline(Nmem(i,k),:,3,i)'); %Extract Quadratic Coefficients.
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                                                  
        
         %Triangle = [[0 0];[1 0];[0 1];[.5 0];[.5 .5];[0 .5]]; %We only needed actual triangle for jacobian
         
         
         CB11 = Q_Terp(Triangle, B11(Nmem(i,k),:,3)'); %"
         CB12 = Q_Terp(Triangle, B12(Nmem(i,k),:,3)'); %"
         CB21 = Q_Terp(Triangle, B21(Nmem(i,k),:,3)'); %"
         CB22 = Q_Terp(Triangle, B22(Nmem(i,k),:,3)'); %"
         CC11 = Q_Terp(Triangle, C11(Nmem(i,k),:,3)'); %"
         CC12 = Q_Terp(Triangle, C12(Nmem(i,k),:,3)'); %"
         CC21 = Q_Terp(Triangle, C21(Nmem(i,k),:,3)'); %"
         CC22 = Q_Terp(Triangle, C22(Nmem(i,k),:,3)'); %"
         
         Evaldxi = Ci(1,2) + Ci(1,4)*PointsElement(:,2) + 2*Ci(1,5)*PointsElement(:,1);%Extract the derivative values because in this term there was a space integration by parts. DERIVS WRONG BC ON STD TRIANGLE NOT DOMAIN!
         Evaldyi = Ci(1,3) + Ci(1,4)*PointsElement(:,1) + 2*Ci(1,6)*PointsElement(:,2);
         
         EvalB11 = CB11(1,1)+CB11(1,2)*PointsElement(:,1) + CB11(1,3)*PointsElement(:,2) + CB11(1,4)* PointsElement(:,1).*PointsElement(:,2) + CB11(1,5)*PointsElement(:,1).^2 + CB11(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalB12 = CB12(1,1)+CB12(1,2)*PointsElement(:,1) + CB12(1,3)*PointsElement(:,2) + CB12(1,4)* PointsElement(:,1).*PointsElement(:,2) + CB12(1,5)*PointsElement(:,1).^2 + CB12(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalB21 = CB21(1,1)+CB21(1,2)*PointsElement(:,1) + CB21(1,3)*PointsElement(:,2) + CB21(1,4)* PointsElement(:,1).*PointsElement(:,2) + CB21(1,5)*PointsElement(:,1).^2 + CB21(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalB22 = CB22(1,1)+CB22(1,2)*PointsElement(:,1) + CB22(1,3)*PointsElement(:,2) + CB22(1,4)* PointsElement(:,1).*PointsElement(:,2) + CB22(1,5)*PointsElement(:,1).^2 + CB22(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalC11 = CC11(1,1)+CC11(1,2)*PointsElement(:,1) + CC11(1,3)*PointsElement(:,2) + CC11(1,4)* PointsElement(:,1).*PointsElement(:,2) + CC11(1,5)*PointsElement(:,1).^2 + CC11(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalC12 = CC12(1,1)+CC12(1,2)*PointsElement(:,1) + CC12(1,3)*PointsElement(:,2) + CC12(1,4)* PointsElement(:,1).*PointsElement(:,2) + CC12(1,5)*PointsElement(:,1).^2 + CC12(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalC21 = CC21(1,1)+CC21(1,2)*PointsElement(:,1) + CC21(1,3)*PointsElement(:,2) + CC21(1,4)* PointsElement(:,1).*PointsElement(:,2) + CC21(1,5)*PointsElement(:,1).^2 + CC21(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         EvalC22 = CC22(1,1)+CC22(1,2)*PointsElement(:,1) + CC22(1,3)*PointsElement(:,2) + CC22(1,4)* PointsElement(:,1).*PointsElement(:,2) + CC22(1,5)*PointsElement(:,1).^2 + CC22(1,6)*PointsElement(:,2).^2;%Find values at standard element.
         
         
         J = abs(J);
         for r=1:6 %Go to all nodes for this triangle                                           
             Cj = Q_Terp(Triangle, NSpline(Nmem(i,k),:,3,NTri(Nmem(i,k),r))'); %Extract Quadratic Coefficients
             Evaldxj = Cj(1,2) + Cj(1,4)*PointsElement(:,2) + 2*Cj(1,5)*PointsElement(:,1);%Extract the derivative values because in this term there was a space integration by parts.
             Evaldyj = Cj(1,3) + Cj(1,4)*PointsElement(:,1) + 2*Cj(1,6)*PointsElement(:,2);
             %BC =
             %[[B11C11+B12C21][B11C12+B12C22];[B21C11+B22C21][B21C12+B22C22]]
             
             %Integrate by Quadrature
             Z = Evaldxi.*(EvalB11.*EvalC11+EvalB12.*EvalC21).*Evaldxj + Evaldyi.*(EvalB21.*EvalC11 + EvalB22.*EvalC21).*Evaldxj + Evaldxi.*(EvalB11.*EvalC12+EvalB12.*EvalC22).*Evaldyj + Evaldyi.*(EvalB21.*EvalC12+EvalB22.*EvalC22).*Evaldyj;
             Z = W*Z;
             P2bd(i-Nodal_Bud(2,1),NTri(Nmem(i,k),r)) = J*Z +  P2bd(i-Nodal_Bud(2,1),NTri(Nmem(i,k),r));

         end
         k = k + 1; %Next possible triangle
    end
end

%Augment the P1 and P2 Matrices
P1 = [P1; P1bd];
P2 = [P2; P2bd];
cond(P1)
cond(P2)
%rP2 = rref(P2);
%rP2(:,size(Nodes,1)-1:size(Nodes,1))
%clear rP2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Integrate Neumann Data %%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%All this code now in NValue
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Equation of type Ac' + Bc = Nval

%We no longer need these and so we clear the variables so I can write with
%A,B as in previous comment.
clear A B11 B12 B21 B22 C11 C12 C21 C22

A = P1;
B = P2;
Ainv = A^(-1);
cinitial = [cinitial;cbd];

%setup time axis
n = floor(tfinal/tstep);
time = 0:tstep:tstep*n;
if floor(tfinal/tstep) ~= tfinal/tstep
time = [time tfinal]; %Augment for the uneven final increment.
end

%We run the integration with Matlab's built in ODE45.  If you want to
%change it's options, you can do it by writing options = odeset(...) and
%plugging this output into the options component of ode45.

%This code computes the Neumann data boundary integrals at each time
%instant.  The Neumann func is specified in NValue.
Nval = @(t) NValue(t,Edge, Etri, Boundary, Vmem, VNodal, ENodal, Nodal, Nodal_Bud, Nodes, NTri, Nmem, vert);
                                                      
options = odeset('RelTol',2,'AbsTol',.1);
odefun = @(t,y) Ainv*(Nval(t) - B*y); %c' = A^-1(Nval - Bc)

[tout, yout] = ode45(odefun, time, cinitial);
yout = yout'; %Have nodal values be listed column-wise.
end

